@extends('admin.layout.page-app')
@section('page_title', __('label.import_question'))
@section('tab_title', __('label.import_question'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">{{__('label.import_question')}}</h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
						<li class="breadcrumb-item"><a href="{{ route('admin.audioquestion.index') }}">{{__('label.questions')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{__('label.import_question')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('admin.audioquestion.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.questions')}}</a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<form id="import_question" enctype="multipart/form-data">
                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{__('label.questions_file')}}<span class="text-danger">*</span></label>
                                <input type="file" name="import_file" class="form-control" accept=".csv" autofocus>
                            </div>
                        </div>
                    </div>
                    <div class="form-row mt-3">
                        <div class="col-md-6">
                            <button type="button" class="btn btn-default mw-120" onclick="import_question()"><i class="fa fa-upload mr-3"></i>{{__('label.upload_file')}}</button>
                            <a class="btn btn-default ml-5" href="{{ route('admin.audioquestion.export') }}"><i class="fa fa-download mr-3"></i>{{__('label.download_sample_file_here')}}</a>
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        </div>
                    </div>
				</form>
                <!-- Instructions -->
                <div class="form-row mt-5">
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <strong class="h5">{{__('label.instructions')}} : </strong>
                            <ul class="mt-3 h6">
                                <li class="py-2">Only <code>.csv</code> files are allowed for Upload.</li>
                                <li class="py-2">Make sure <code>category_id</code>, <code>skill_id</code>, <code>classification_id</code>, and <code>level_id</code> match existing IDs in the system. If any of them are not applicable, Pass <code>0</code>.</li>
                                <li class="py-2">Image and Audio URLs should be direct and valid (e.g., <code>https://yourdomain.com/images/question1.png</code>).</li>
                                <li class="py-2"><strong>Note</strong> and <strong>Image</strong> fields are optional — You can leave them blank if not Required.</li>
                                <li class="py-2"><strong>Answer</strong> must be a number between <code>1</code> and <code>4</code> only — do not use letters like A, B, C, or D.</li>
                            </ul>
                        </div>
                    </div>
                </div>
			</div>
		</div>
	</div>
@endsection

@section('pagescript')
	<script>
		function import_question(){

			var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

				$("#dvloader").show();
				var formData = new FormData($("#import_question")[0]);
				$.ajax({
					type:'POST',
					url:'{{ route("admin.audioquestion.import.save") }}',
					data:formData,
					cache:false,
					contentType: false,
					processData: false,
					success:function(resp){
						$("#dvloader").hide();
						get_responce_message(resp, 'import_question', '{{ route("admin.audioquestion.index") }}');
					},
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
				});
			} else {
                showError();
            }
		}
	</script>
@endsection